﻿/**********************************
* @file timer3.c
* @brief
* @author
* @version V0.0.0
* @date 2020.02.18
* @details 
* @copyright
* @note 
**********************************/

/* Includes ------------------------------------------------------------------*/

#include "CSU38F20.h"
#include "timer3.h"

/* Fuction Declare ----------------------------------------------------------*/

/***********************************
* @fn  void timer3_init(void)
* @brief  PWM output .
* @param[out] none.
* @param[in] none.
* @return none.
************************************/
void timer3_init(void);

/***********************************
* @fn  timer3_pwm_period(unsigned int period)
* @brief set pwm period
* @param[out] none.
* @param[in] pwm period.
* @return none.
************************************/
void timer3_pwm_period(unsigned int period);

/***********************************
* @fn  timer3_pwm_duty(unsigned int duty)
* @brief set pwm duty
* @param[out] none.
* @param[in] pwm duty.
* @return none.
************************************/
void timer3_pwm_duty(unsigned int duty);

/***********************************
* @fn  timer3_dt_time(unsigned char dt_time)
* @brief set timer3 dt time
* @param[out] none.
* @param[in] dt_time.
* @return none.
************************************/
void timer3_dt_time(unsigned char dt_time);

/* Fuction Define -----------------------------------------------------------*/

/***********************************
* @fn  timer3_set_pwm_period(unsigned int period)
* @brief set pwm period
* @param[out] none.
* @param[in] pwm period.
* @return none.
************************************/

void timer3_pwm_period(unsigned int period)
{
    unsigned int periodbuf[2]={0};
    periodbuf[0] = (unsigned int)(period >> 8);
	periodbuf[1] = (unsigned int)(period & 0x00ff);
    TM3INH = periodbuf[0];
    TM3IN = periodbuf[1];
}

/***********************************
* @fn  timer3_pwm_duty(unsigned int duty)
* @brief set pwm duty
* @param[out] none.
* @param[in] pwm duty.
* @return none.
************************************/

void timer3_pwm_duty(unsigned int duty)
{
    unsigned int dutybuf[2]={0};
    dutybuf[0] = (unsigned int)(duty >> 8);
	dutybuf[1] = (unsigned int)(duty&0x00ff);
    TM3RH = dutybuf[0];
    TM3R = dutybuf[1];
}

/***********************************
* @fn  void timer3_init(void)
* @brief  PWM output .
* @param[out] none.
* @param[in] none.
* @return none.
************************************/

void timer3_init(void)
{
	timer3_clk_source();	//CKT3的分频时钟
	timer3_div_32();		//CPUCLK/32，62.5KHz
}

/***********************************
* @fn  timer3_dt_time(unsigned char dt_time)
* @brief set timer3 dt time
* @param[out] none.
* @param[in] dt_time.
* @return none.
************************************/
void timer3_dt_time(unsigned char dt_time)
{
	TM3CON2 &= 0xC7;
	dt_time &= 0x07;
	dt_time <<= 3;
	TM3CON2 |= dt_time;
}
	
	